/*
 * Decompiled with CFR 0.152.
 */
package moe.amy.api.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import moe.amy.api.command.CommandExecutor;
import moe.amy.api.text.TranslatedMessage;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.jetbrains.annotations.NotNull;

public abstract class Command {
    private final String name;
    private final String permission;
    private final String[] aliases;
    private final List<Command> subCommands = new ArrayList<Command>();

    public Command(String name, String permission, String ... aliases) {
        this.name = name;
        this.permission = permission;
        this.aliases = aliases;
    }

    public void registerSubCommand(@NotNull Command subCommand) {
        this.subCommands.add(subCommand);
    }

    public void treeExecute(CommandExecutor sender, String label, String[] args) {
        if (args.length != 0) {
            String subCheck = args[0];
            for (Command sub : this.subCommands) {
                boolean isSub = sub.getName().equalsIgnoreCase(subCheck);
                if (!isSub) {
                    for (String alias : this.aliases) {
                        if (!alias.equalsIgnoreCase(subCheck)) continue;
                        isSub = true;
                        break;
                    }
                }
                if (!isSub) continue;
                String[] newArgs = Arrays.copyOfRange(args, 1, args.length);
                sub.treeExecute(sender, label + " " + args[0], newArgs);
                return;
            }
        }
        if (sender.hasPermission(this.getPermission())) {
            this.execute(sender, label, args);
        } else {
            sender.sendMessage(new TranslatedMessage("amypi:command.error.no_permission").colour((TextColor)NamedTextColor.RED));
        }
    }

    public List<String> treeTab(CommandExecutor sender, String label, String[] args) {
        if (args.length != 0) {
            String subCheck = args[0];
            for (Command sub : this.subCommands) {
                boolean isSub = sub.getName().equalsIgnoreCase(subCheck);
                if (!isSub) {
                    for (String alias : this.aliases) {
                        if (!alias.equalsIgnoreCase(subCheck)) continue;
                        isSub = true;
                        break;
                    }
                }
                if (!isSub) continue;
                String[] newArgs = Arrays.copyOfRange(args, 1, args.length);
                return sub.treeTab(sender, label + " " + args[0], newArgs);
            }
        }
        if (sender.hasPermission(this.getPermission())) {
            List<String> results = this.onTabComplete(sender, label, args);
            for (Command sub : this.subCommands) {
                if (!sender.hasPermission(sub.getPermission()) || !sub.getName().toLowerCase().startsWith(args[0].toLowerCase())) continue;
                results.add(sub.getName());
            }
            return results;
        }
        return new ArrayList<String>();
    }

    public abstract void execute(@NotNull CommandExecutor var1, @NotNull String var2, @NotNull String[] var3);

    @NotNull
    public abstract List<String> onTabComplete(@NotNull CommandExecutor var1, @NotNull String var2, @NotNull String[] var3);

    public String getName() {
        return this.name;
    }

    public String getPermission() {
        return this.permission;
    }

    public String[] getAliases() {
        return this.aliases;
    }

    public List<Command> getSubCommands() {
        return this.subCommands;
    }
}

