/*
 * Decompiled with CFR 0.152.
 */
package moe.amy.api.text;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import moe.amy.api.AmyPI;
import moe.amy.api.command.CommandExecutor;
import moe.amy.api.player.OnlinePlayer;
import moe.amy.api.text.Language;
import moe.amy.api.text.LiteralMessage;
import moe.amy.api.text.TextUtils;
import moe.amy.api.text.TranslatedMessage;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;

public abstract class TextMessage {
    protected String message;
    protected boolean parseTags;
    protected TextColor colour;
    protected List<TextDecoration> decorations = new ArrayList<TextDecoration>();
    protected List<TextDecoration> undecorations = new ArrayList<TextDecoration>();
    protected ClickEvent clickMessage;
    protected TextMessage hoverMessage;
    protected char center = '\u0000';
    protected TextColor centerColour;
    protected List<TextDecoration> centerFormats = new ArrayList<TextDecoration>();
    protected int centerSize = 308;
    protected final HashMap<String, TextMessage> variables = new HashMap();
    protected final List<TextMessage> appends = new ArrayList<TextMessage>();

    public TextMessage(String message, boolean parseTags) {
        this.message = message;
        this.parseTags = parseTags;
    }

    public TextMessage colour(TextColor colour) {
        this.colour = colour;
        return this;
    }

    public TextMessage decorate(TextDecoration ... decorations) {
        this.decorations.addAll(Arrays.asList(decorations));
        return this;
    }

    public TextMessage undecorate(TextDecoration ... decorations) {
        this.undecorations.addAll(Arrays.asList(decorations));
        return this;
    }

    public TextMessage click(ClickEvent onClick) {
        this.clickMessage = onClick;
        return this;
    }

    public TextMessage hover(TextMessage onHover) {
        this.hoverMessage = onHover;
        return this;
    }

    public TextMessage variable(String key, TextMessage value) {
        this.variables.put(key, value);
        return this;
    }

    public TextMessage variable(String key, String rawText) {
        this.variables.put(key, new LiteralMessage(rawText));
        return this;
    }

    public TextMessage variable(String key, int value) {
        this.variables.put(key, new LiteralMessage(Integer.toString(value)));
        return this;
    }

    public TextMessage variable(String key, long value) {
        this.variables.put(key, new LiteralMessage(Long.toString(value)));
        return this;
    }

    public TextMessage variable(String key, float value) {
        this.variables.put(key, new LiteralMessage(Float.toString(value)));
        return this;
    }

    public TextMessage variable(String key, double value) {
        this.variables.put(key, new LiteralMessage(Double.toString(value)));
        return this;
    }

    public TextMessage variable(String key, char value) {
        this.variables.put(key, new LiteralMessage(Character.toString(value)));
        return this;
    }

    public TextMessage append(TextMessage other) {
        this.appends.add(other);
        return this;
    }

    public TextMessage center() {
        this.center = (char)32;
        return this;
    }

    public TextMessage center(int size) {
        this.center = (char)32;
        this.centerSize = size;
        return this;
    }

    public TextMessage center(char padding, TextColor colour, TextDecoration ... formats) {
        this.center = padding;
        this.centerColour = colour;
        this.centerFormats.addAll(Arrays.asList(formats));
        return this;
    }

    public TextMessage center(char padding, int size, TextColor colour, TextDecoration ... formats) {
        this.center = padding;
        this.centerSize = size;
        this.centerColour = colour;
        this.centerFormats.addAll(Arrays.asList(formats));
        return this;
    }

    public void send(CommandExecutor player) {
        player.sendMessage(this);
    }

    public void send(CommandExecutor[] players) {
        for (CommandExecutor player : players) {
            player.sendMessage(this);
        }
    }

    public void broadcast() {
        AmyPI.getConsole().sendMessage(this);
        for (OnlinePlayer onlinePlayer : AmyPI.getPlayerManager().getAllPlayers()) {
            onlinePlayer.sendMessage(this);
        }
    }

    public Component build(Language language) {
        Component component;
        MiniMessage mm = MiniMessage.miniMessage();
        ArrayList<TagResolver.Single> placeholders = new ArrayList<TagResolver.Single>(this.variables.size());
        for (Map.Entry<String, TextMessage> entry : this.variables.entrySet()) {
            placeholders.add(Placeholder.component((String)entry.getKey(), (ComponentLike)entry.getValue().build(language)));
        }
        String message = this.message;
        if (this instanceof TranslatedMessage) {
            message = language.translate(message);
        }
        if (this.parseTags) {
            component = this.hasColour(message) ? mm.deserialize(message, (TagResolver[])placeholders.toArray(new TagResolver.Single[0])) : mm.deserialize(message, (TagResolver[])placeholders.toArray(new TagResolver.Single[0])).color(this.colour);
        } else {
            Iterator<Object> m = mm.escapeTags(message);
            component = mm.deserialize((String)((Object)m), (TagResolver[])placeholders.toArray(new TagResolver.Single[0])).color(this.colour);
        }
        for (TextDecoration format : this.undecorations) {
            component = component.decoration(format, false);
        }
        for (TextDecoration format : this.decorations) {
            component = component.decorate(format);
        }
        if (this.clickMessage != null) {
            component = component.clickEvent(this.clickMessage);
        }
        if (this.hoverMessage != null) {
            component = component.hoverEvent((HoverEventSource)HoverEvent.showText((Component)this.hoverMessage.build(language)));
        }
        for (TextMessage append : this.appends) {
            component = component.append(append.build(language));
        }
        if (this.center != '\u0000') {
            String legacy = LegacyComponentSerializer.legacySection().serialize(component);
            String padding = TextUtils.getPaddingForCenter(legacy, this.center, this.centerSize);
            Component pre = component;
            component = Component.text((String)padding).color(this.centerColour);
            for (TextDecoration format : this.centerFormats) {
                component = component.decorate(format);
            }
            component = ((TextComponent)((TextComponent)Component.text((String)"").append(component)).append(pre)).append(component);
        }
        return component;
    }

    private boolean hasColour(String message) {
        for (NamedTextColor colour : NamedTextColor.NAMES.values()) {
            if (!message.toLowerCase().startsWith("<" + colour + ">") || !message.toLowerCase().endsWith("</" + colour + ">")) continue;
            return true;
        }
        return Pattern.matches("^<#[0-9a-zA-Z]{6}>.*<\\/#[0-9a-zA-Z]{6}>$", message);
    }
}

