/*
 * Decompiled with CFR 0.152.
 */
package moe.amy.api.text;

import moe.amy.api.text.DefaultFontInfo;

public class TextUtils {
    public static final int CHAT_SIZE = 308;
    public static final int MOTD_SIZE = 256;

    public static String getPaddingForCenter(String message) {
        return TextUtils.getPaddingForCenter(message, '\u0000', 308);
    }

    public static String getPaddingForCenter(String message, char pad) {
        return TextUtils.getPaddingForCenter(message, pad, 308);
    }

    public static String getPaddingForCenter(String message, int maxPixels) {
        return TextUtils.getPaddingForCenter(message, '\u0000', maxPixels);
    }

    public static String getPaddingForCenter(String message, char pad, int maxPixels) {
        String toCheck = message.replaceAll("\u00a7#[0-9a-fA-F]{6}", "").replaceAll("\u00a7x[0-9a-fA-F]{6}", "");
        double messagePxSize = 0.0;
        boolean previousCode = false;
        boolean isBold = false;
        for (char c : toCheck.toCharArray()) {
            if (c == '\u00a7') {
                previousCode = true;
                continue;
            }
            if (previousCode) {
                previousCode = false;
                if (c == 'l' || c == 'L') {
                    isBold = true;
                    continue;
                }
                isBold = false;
            } else {
                DefaultFontInfo dFI = DefaultFontInfo.getDefaultFontInfo(c);
                messagePxSize += isBold ? (double)dFI.getBoldLength() : (double)dFI.getLength();
                messagePxSize += 1.0;
            }
            if (messagePxSize >= (double)maxPixels) break;
        }
        double halvedMessageSize = messagePxSize / 2.0;
        double toCompensate = (double)maxPixels / 2.0 - halvedMessageSize;
        double spaceLength = DefaultFontInfo.getDefaultFontInfo(pad == '\u0000' ? (char)' ' : (char)pad).getLength() + 1;
        int compensated = 0;
        StringBuilder sb = new StringBuilder();
        while ((double)compensated < toCompensate) {
            sb.append(pad == '\u0000' ? (char)' ' : (char)pad);
            compensated = (int)((double)compensated + spaceLength);
        }
        return sb.toString();
    }
}

