/*
 * Decompiled with CFR 0.152.
 */
package moe.amy.paper.inventory.item;

import com.mojang.authlib.GameProfile;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.UUID;
import javax.annotation.CheckReturnValue;
import moe.amy.api.player.OnlinePlayer;
import moe.amy.api.text.Language;
import moe.amy.api.text.TextMessage;
import moe.amy.paper.inventory.item.ItemDictionary;
import moe.amy.paper.inventory.item.ItemIdentifier;
import moe.amy.paper.inventory.item.ItemInteractHandler;
import moe.amy.paper.inventory.item.ItemInteractListener;
import moe.amy.paper.util.SkinData;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;

public class ItemFactory {
    private final ItemStack itemStack;
    private final ItemMeta meta;

    private ItemFactory(ItemStack itemStack) {
        this.itemStack = itemStack;
        this.meta = itemStack.getItemMeta();
    }

    private ItemFactory(Material material, int amount) {
        this.itemStack = new ItemStack(material, amount);
        this.meta = this.itemStack.getItemMeta();
    }

    @CheckReturnValue
    public static ItemFactory createItemStack(Material material) {
        return new ItemFactory(material, 1);
    }

    @CheckReturnValue
    public static ItemFactory createItemStack(Material material, int amount) {
        return new ItemFactory(material, amount);
    }

    @CheckReturnValue
    public static ItemFactory modifyItemStack(ItemStack itemStack) {
        return new ItemFactory(itemStack);
    }

    @CheckReturnValue
    public static ItemFactory cloneItemStack(ItemStack itemStack) {
        return new ItemFactory(itemStack.clone());
    }

    @CheckReturnValue
    public static ItemFactory createSkullItem(String skullOwner) {
        return new ItemFactory(Material.PLAYER_HEAD, 1).setSkullOwner(skullOwner);
    }

    @CheckReturnValue
    public static ItemFactory createSkullItem(OfflinePlayer skullOwner) {
        return new ItemFactory(Material.PLAYER_HEAD, 1).setSkullOwner(skullOwner);
    }

    @CheckReturnValue
    public static ItemFactory createSkullItem(SkinData skin) {
        return new ItemFactory(Material.PLAYER_HEAD, 1).setSkullOwner(skin);
    }

    @CheckReturnValue
    public static ItemFactory createPotionItem(PotionData data) {
        return new ItemFactory(Material.POTION, 1).setBasePotionData(data);
    }

    @CheckReturnValue
    public static ItemFactory createPotionItem(PotionType type) {
        return new ItemFactory(Material.POTION, 1).setBasePotionEffect(type);
    }

    @CheckReturnValue
    public static ItemFactory createPotionItem(PotionType type, boolean extended, boolean upgraded) {
        return new ItemFactory(Material.POTION, 1).setBasePotionEffect(type, extended, upgraded);
    }

    @CheckReturnValue
    public static ItemFactory createPotionItem(PotionEffect ... effects) {
        return new ItemFactory(Material.POTION, 1).addPotionEffects(effects);
    }

    @CheckReturnValue
    public static ItemFactory createPotionItem(PotionEffectType effect, int duration, int amplifier) {
        return new ItemFactory(Material.POTION, 1).addPotionEffect(effect, duration, amplifier);
    }

    @CheckReturnValue
    public static ItemFactory createSplashPotionItem(PotionData data) {
        return new ItemFactory(Material.SPLASH_POTION, 1).setBasePotionData(data);
    }

    @CheckReturnValue
    public static ItemFactory createSplashPotionItem(PotionType type) {
        return new ItemFactory(Material.SPLASH_POTION, 1).setBasePotionEffect(type);
    }

    @CheckReturnValue
    public static ItemFactory createSplashPotionItem(PotionType type, boolean extended, boolean upgraded) {
        return new ItemFactory(Material.SPLASH_POTION, 1).setBasePotionEffect(type, extended, upgraded);
    }

    @CheckReturnValue
    public static ItemFactory createSplashPotionItem(PotionEffect ... effects) {
        return new ItemFactory(Material.SPLASH_POTION, 1).addPotionEffects(effects);
    }

    @CheckReturnValue
    public static ItemFactory createSplashPotionItem(PotionEffectType effect, int duration, int amplifier) {
        return new ItemFactory(Material.SPLASH_POTION, 1).addPotionEffect(effect, duration, amplifier);
    }

    @CheckReturnValue
    public static ItemFactory createLingeringPotionItem(PotionData data) {
        return new ItemFactory(Material.LINGERING_POTION, 1).setBasePotionData(data);
    }

    @CheckReturnValue
    public static ItemFactory createLingeringPotionItem(PotionType type) {
        return new ItemFactory(Material.LINGERING_POTION, 1).setBasePotionEffect(type);
    }

    @CheckReturnValue
    public static ItemFactory createLingeringPotionItem(PotionType type, boolean extended, boolean upgraded) {
        return new ItemFactory(Material.LINGERING_POTION, 1).setBasePotionEffect(type, extended, upgraded);
    }

    @CheckReturnValue
    public static ItemFactory createLingeringPotionItem(PotionEffect ... effects) {
        return new ItemFactory(Material.LINGERING_POTION, 1).addPotionEffects(effects);
    }

    @CheckReturnValue
    public static ItemFactory createLingeringPotionItem(PotionEffectType effect, int duration, int amplifier) {
        return new ItemFactory(Material.LINGERING_POTION, 1).addPotionEffect(effect, duration, amplifier);
    }

    @CheckReturnValue
    public ItemFactory setAmount(int amount) {
        this.itemStack.setAmount(amount);
        return this;
    }

    @CheckReturnValue
    public ItemFactory setName(TextMessage name) {
        int id = ItemDictionary.add(name.undecorate(TextDecoration.ITALIC));
        this.meta.displayName((Component)Component.text((String)("\u00a7{i." + id + "}")));
        return this;
    }

    @CheckReturnValue
    public ItemFactory setName(Language language, TextMessage name) {
        this.meta.displayName(name.undecorate(TextDecoration.ITALIC).build(language));
        return this;
    }

    @CheckReturnValue
    public ItemFactory setName(Component name) {
        this.meta.displayName(name);
        return this;
    }

    @CheckReturnValue
    public ItemFactory setLore(TextMessage ... lore) {
        ArrayList<TextComponent> loreComponent = new ArrayList<TextComponent>();
        for (TextMessage line : lore) {
            if (line == null) {
                loreComponent.add(Component.text((String)""));
                continue;
            }
            int id = ItemDictionary.add(line.undecorate(TextDecoration.ITALIC));
            loreComponent.add(Component.text((String)("\u00a7{i." + id + "}")));
        }
        this.meta.lore(loreComponent);
        return this;
    }

    @CheckReturnValue
    public ItemFactory setLore(Language language, TextMessage ... lore) {
        ArrayList<Object> loreComponent = new ArrayList<Object>();
        for (TextMessage line : lore) {
            if (line == null) {
                loreComponent.add(Component.text((String)""));
                continue;
            }
            loreComponent.add(line.undecorate(TextDecoration.ITALIC).build(language));
        }
        this.meta.lore(loreComponent);
        return this;
    }

    @CheckReturnValue
    public ItemFactory setLore(Component ... lore) {
        this.meta.lore(Arrays.asList(lore));
        return this;
    }

    @CheckReturnValue
    public ItemFactory setNameAndLore(TextMessage name, TextMessage ... lore) {
        return this.setName(name).setLore(lore);
    }

    @CheckReturnValue
    public ItemFactory setNameAndLore(Language language, TextMessage name, TextMessage ... lore) {
        return this.setName(language, name).setLore(language, lore);
    }

    @CheckReturnValue
    public ItemFactory setNameAndLore(Component name, Component ... lore) {
        return this.setName(name).setLore(lore);
    }

    @CheckReturnValue
    public ItemFactory addEnchantment(Enchantment enchantment, int level) {
        this.meta.addEnchant(enchantment, level, true);
        return this;
    }

    @CheckReturnValue
    public ItemFactory addEnchantments(Map<Enchantment, Integer> enchantments) {
        for (Map.Entry<Enchantment, Integer> enchant : enchantments.entrySet()) {
            this.meta.addEnchant(enchant.getKey(), enchant.getValue().intValue(), true);
        }
        return this;
    }

    @CheckReturnValue
    public ItemFactory removeEnchantments(Enchantment ... enchantments) {
        for (Enchantment enchant : enchantments) {
            this.meta.removeEnchant(enchant);
        }
        return this;
    }

    @CheckReturnValue
    public ItemFactory setUnbreakable(boolean unbreakable) {
        this.meta.setUnbreakable(unbreakable);
        return this;
    }

    @CheckReturnValue
    public ItemFactory setUnbreakable(boolean unbreakable, boolean hide) {
        this.meta.setUnbreakable(unbreakable);
        if (hide && unbreakable) {
            this.meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_UNBREAKABLE});
        }
        return this;
    }

    @CheckReturnValue
    public ItemFactory addAttribute(Attribute attribute, String name, double amount, AttributeModifier.Operation operation, EquipmentSlot ... slots) {
        for (EquipmentSlot slot : slots) {
            AttributeModifier modifier = new AttributeModifier(UUID.randomUUID(), name, amount, operation, slot);
            this.meta.addAttributeModifier(attribute, modifier);
        }
        return this;
    }

    @CheckReturnValue
    public ItemFactory addAttribute(Attribute attribute, double amount, AttributeModifier.Operation operation, EquipmentSlot ... slots) {
        return this.addAttribute(attribute, attribute.name().toLowerCase().replaceFirst("_", "."), amount, operation, slots);
    }

    @CheckReturnValue
    public ItemFactory addAttribute(Attribute attribute, String name, double amount, EquipmentSlot ... slots) {
        return this.addAttribute(attribute, name, amount, AttributeModifier.Operation.ADD_NUMBER, slots);
    }

    @CheckReturnValue
    public ItemFactory addAttribute(Attribute attribute, double amount, EquipmentSlot ... slots) {
        return this.addAttribute(attribute, amount, AttributeModifier.Operation.ADD_NUMBER, slots);
    }

    @CheckReturnValue
    public ItemFactory removeAttributes(Attribute ... attributes) {
        for (Attribute attribute : attributes) {
            this.meta.removeAttributeModifier(attribute);
        }
        return this;
    }

    @CheckReturnValue
    public ItemFactory removeAttributes(EquipmentSlot ... slots) {
        for (EquipmentSlot slot : slots) {
            this.meta.removeAttributeModifier(slot);
        }
        return this;
    }

    @CheckReturnValue
    public ItemFactory addItemFlags(ItemFlag ... flags) {
        this.meta.addItemFlags(flags);
        return this;
    }

    @CheckReturnValue
    public ItemFactory removeItemFlags(ItemFlag ... flags) {
        this.meta.removeItemFlags(flags);
        return this;
    }

    @CheckReturnValue
    public ItemFactory setOnInteract(ItemInteractHandler listener) {
        ItemIdentifier itemId = new ItemIdentifier(this.itemStack.getType(), this.meta.displayName(), null);
        ItemInteractListener.instance.addHandler(itemId, listener);
        return this;
    }

    @CheckReturnValue
    public ItemFactory setOnInteract(OnlinePlayer player, ItemInteractHandler listener) {
        ItemIdentifier itemId = new ItemIdentifier(this.itemStack.getType(), this.meta.displayName(), player);
        ItemInteractListener.instance.addHandler(itemId, listener);
        return this;
    }

    @CheckReturnValue
    public ItemFactory setUnlimited(boolean unlimited) {
        ItemIdentifier itemId = new ItemIdentifier(this.itemStack.getType(), this.meta.displayName(), null);
        if (unlimited) {
            ItemInteractListener.instance.unlimited.add(itemId);
        } else {
            ItemInteractListener.instance.unlimited.remove(itemId);
        }
        return this;
    }

    @CheckReturnValue
    public ItemFactory setDurability(int durability) {
        ItemMeta itemMeta = this.meta;
        if (!(itemMeta instanceof Damageable)) {
            throw new IllegalStateException("Item is not damageable");
        }
        Damageable d = (Damageable)itemMeta;
        d.setDamage(this.itemStack.getType().getMaxDurability() - durability);
        return this;
    }

    @CheckReturnValue
    public ItemFactory setDamage(int damage) {
        ItemMeta itemMeta = this.meta;
        if (!(itemMeta instanceof Damageable)) {
            throw new IllegalStateException("Item is not damageable");
        }
        Damageable d = (Damageable)itemMeta;
        d.setDamage(damage);
        return this;
    }

    @CheckReturnValue
    public ItemFactory setSkullOwner(String name) {
        if (!(this.meta instanceof SkullMeta)) {
            throw new IllegalStateException("Item is not a player head!");
        }
        return this.setSkullOwner(Bukkit.getOfflinePlayer((String)name));
    }

    @CheckReturnValue
    public ItemFactory setSkullOwner(OfflinePlayer player) {
        ItemMeta itemMeta = this.meta;
        if (!(itemMeta instanceof SkullMeta)) {
            throw new IllegalStateException("Item is not a player head!");
        }
        SkullMeta sm = (SkullMeta)itemMeta;
        sm.setOwningPlayer(player);
        return this;
    }

    @CheckReturnValue
    public ItemFactory setSkullOwner(SkinData skin) {
        ItemMeta itemMeta = this.meta;
        if (!(itemMeta instanceof SkullMeta)) {
            throw new IllegalStateException("Item is not a player head!");
        }
        SkullMeta sm = (SkullMeta)itemMeta;
        try {
            Method setProfile = sm.getClass().getDeclaredMethod("setProfile", GameProfile.class);
            setProfile.setAccessible(true);
            GameProfile gp = skin.toGameProfile("Player");
            setProfile.invoke((Object)sm, gp);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this;
    }

    @CheckReturnValue
    public ItemFactory setBasePotionData(PotionData data) {
        ItemMeta itemMeta = this.meta;
        if (!(itemMeta instanceof PotionMeta)) {
            throw new IllegalStateException("Item is not a potion!");
        }
        PotionMeta pm = (PotionMeta)itemMeta;
        pm.setBasePotionData(data);
        return this;
    }

    @CheckReturnValue
    public ItemFactory setBasePotionEffect(PotionType type) {
        ItemMeta itemMeta = this.meta;
        if (!(itemMeta instanceof PotionMeta)) {
            throw new IllegalStateException("Item is not a potion!");
        }
        PotionMeta pm = (PotionMeta)itemMeta;
        pm.setBasePotionData(new PotionData(type));
        return this;
    }

    @CheckReturnValue
    public ItemFactory setBasePotionEffect(PotionType type, boolean extended, boolean upgraded) {
        ItemMeta itemMeta = this.meta;
        if (!(itemMeta instanceof PotionMeta)) {
            throw new IllegalStateException("Item is not a potion!");
        }
        PotionMeta pm = (PotionMeta)itemMeta;
        pm.setBasePotionData(new PotionData(type, extended, upgraded));
        return this;
    }

    @CheckReturnValue
    public ItemFactory addPotionEffects(PotionEffect ... effects) {
        PotionEffect[] potionEffectArray = this.meta;
        if (!(potionEffectArray instanceof PotionMeta)) {
            throw new IllegalStateException("Item is not a potion!");
        }
        PotionMeta pm = (PotionMeta)potionEffectArray;
        for (PotionEffect effect : effects) {
            pm.addCustomEffect(effect, true);
        }
        return this;
    }

    @CheckReturnValue
    public ItemFactory addPotionEffect(PotionEffectType effect, int duration, int amplifier) {
        ItemMeta itemMeta = this.meta;
        if (!(itemMeta instanceof PotionMeta)) {
            throw new IllegalStateException("Item is not a potion!");
        }
        PotionMeta pm = (PotionMeta)itemMeta;
        pm.addCustomEffect(new PotionEffect(effect, duration, amplifier), true);
        return this;
    }

    @CheckReturnValue
    public ItemFactory setPotionColour(Color colour) {
        ItemMeta itemMeta = this.meta;
        if (!(itemMeta instanceof PotionMeta)) {
            throw new IllegalStateException("Item is not a potion!");
        }
        PotionMeta pm = (PotionMeta)itemMeta;
        pm.setColor(colour);
        return this;
    }

    public ItemStack build() {
        this.itemStack.setItemMeta(this.meta);
        return this.itemStack;
    }
}

