/*
 * Decompiled with CFR 0.152.
 */
package moe.amy.paper.inventory.item;

import moe.amy.api.AmyPI;
import moe.amy.api.player.OnlinePlayer;
import org.bukkit.event.Cancellable;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;

public class ItemInteractEvent
implements Cancellable {
    private final OnlinePlayer player;
    private final ItemStack item;
    private InventoryClickEvent inventoryClickEvent;
    private PlayerInteractEvent playerInteractEvent;

    protected ItemInteractEvent(InventoryClickEvent event) {
        this.player = AmyPI.getPlayerManager().getOnlinePlayer(event.getWhoClicked().getUniqueId());
        this.item = event.getCurrentItem();
        this.inventoryClickEvent = event;
    }

    protected ItemInteractEvent(PlayerInteractEvent event) {
        this.player = AmyPI.getPlayerManager().getOnlinePlayer(event.getPlayer().getUniqueId());
        this.item = event.getItem();
        this.playerInteractEvent = event;
    }

    public OnlinePlayer getPlayer() {
        return this.player;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public InventoryClickEvent getInventoryClickEvent() {
        return this.inventoryClickEvent;
    }

    public PlayerInteractEvent getPlayerInteractEvent() {
        return this.playerInteractEvent;
    }

    public boolean isCancelled() {
        if (this.inventoryClickEvent != null) {
            return this.inventoryClickEvent.isCancelled();
        }
        return this.playerInteractEvent.isCancelled();
    }

    public void setCancelled(boolean cancelled) {
        if (this.inventoryClickEvent != null) {
            this.inventoryClickEvent.setCancelled(cancelled);
        } else {
            this.playerInteractEvent.setCancelled(cancelled);
        }
    }
}

