/*
 * Decompiled with CFR 0.152.
 */
package moe.amy.paper.inventory.item;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import moe.amy.api.AmyPI;
import moe.amy.api.player.OnlinePlayer;
import moe.amy.paper.AmyPIPaper;
import moe.amy.paper.inventory.item.ItemIdentifier;
import moe.amy.paper.inventory.item.ItemInteractEvent;
import moe.amy.paper.inventory.item.ItemInteractHandler;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class ItemInteractListener
implements Listener {
    private final Map<ItemIdentifier, ItemInteractHandler> handlers = new HashMap<ItemIdentifier, ItemInteractHandler>();
    protected static ItemInteractListener instance;
    protected final List<ItemIdentifier> unlimited = new ArrayList<ItemIdentifier>();

    public ItemInteractListener() {
        instance = this;
    }

    protected void addHandler(ItemIdentifier item, ItemInteractHandler handler) {
        this.handlers.put(item, handler);
    }

    @EventHandler
    public void onItemInteract(PlayerInteractEvent event) {
        if (event.getItem() != null && event.getHand() == EquipmentSlot.HAND) {
            OnlinePlayer op = AmyPI.getPlayerManager().getOnlinePlayer(event.getPlayer().getUniqueId());
            Material type = event.getItem().getType();
            Component name = event.getItem().getItemMeta() != null ? event.getItem().getItemMeta().displayName() : null;
            ItemIdentifier item = new ItemIdentifier(type, name, op);
            ItemInteractHandler handler = this.handlers.get(item);
            for (ItemIdentifier o : this.handlers.keySet()) {
                if (!item.equals(o)) continue;
                handler = this.handlers.get(o);
            }
            if (handler != null) {
                event.setCancelled(true);
                OnlinePlayer player = AmyPI.getPlayerManager().getOnlinePlayer(event.getPlayer().getUniqueId());
                if (player.triggerCooldown("item.interact", 500)) {
                    handler.onInteract(new ItemInteractEvent(event));
                }
            } else if (this.unlimited.contains(item)) {
                ItemStack clone = event.getItem().clone();
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)AmyPIPaper.getInstance(), () -> event.getPlayer().getInventory().setItem(event.getHand(), clone), 1L);
            }
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        HumanEntity humanEntity;
        if (event.getCurrentItem() != null && (humanEntity = event.getWhoClicked()) instanceof Player) {
            Player player = (Player)humanEntity;
            OnlinePlayer op = AmyPI.getPlayerManager().getOnlinePlayer(player.getUniqueId());
            Material type = event.getCurrentItem().getType();
            Component name = event.getCurrentItem().getItemMeta() != null ? event.getCurrentItem().getItemMeta().displayName() : null;
            ItemIdentifier item = new ItemIdentifier(type, name, op);
            ItemInteractHandler handler = this.handlers.get(item);
            for (ItemIdentifier o : this.handlers.keySet()) {
                if (!item.equals(o)) continue;
                handler = this.handlers.get(o);
            }
            if (handler != null) {
                event.setCancelled(true);
                handler.onInteract(new ItemInteractEvent(event));
            }
        }
    }
}

