/*
 * Decompiled with CFR 0.152.
 */
package moe.amy.paper.inventory.item;

import com.comphenix.packetwrapper.WrapperPlayServerSetSlot;
import com.comphenix.packetwrapper.WrapperPlayServerWindowItems;
import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketEvent;
import java.util.ArrayList;
import moe.amy.api.AmyPI;
import moe.amy.api.player.OnlinePlayer;
import moe.amy.api.text.TextMessage;
import moe.amy.paper.inventory.item.ItemDictionary;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class ItemPacketListener
extends PacketAdapter {
    public ItemPacketListener(Plugin plugin) {
        super(plugin, new PacketType[]{PacketType.Play.Server.SET_SLOT, PacketType.Play.Server.WINDOW_ITEMS});
    }

    public void onPacketSending(PacketEvent event) {
        OnlinePlayer player = AmyPI.getPlayerManager().getOnlinePlayer(event.getPlayer().getUniqueId());
        if (event.getPacketType() == PacketType.Play.Server.SET_SLOT) {
            WrapperPlayServerSetSlot packet = new WrapperPlayServerSetSlot(event.getPacket());
            ItemStack item = packet.getSlotData();
            if (item != null) {
                int id;
                TextMessage message;
                String name;
                Component componentName;
                ItemMeta meta = item.getItemMeta();
                if (meta != null && (componentName = meta.displayName()) != null && (name = PlainTextComponentSerializer.plainText().serialize(componentName)).startsWith("\u00a7{i.") && (message = ItemDictionary.get(id = Integer.parseInt(name.split("\\.")[1].replace("}", "")))) != null) {
                    meta.displayName(message.build(player.getLanguage()));
                    item.setItemMeta(meta);
                }
                if ((meta = item.getItemMeta()) != null && meta.lore() != null) {
                    ArrayList<Component> loreList = new ArrayList<Component>(meta.lore().size());
                    for (int i = 0; i < meta.lore().size(); ++i) {
                        int id2;
                        TextMessage message2;
                        String lore;
                        Component componentLore = (Component)meta.lore().get(i);
                        if (componentLore != null && (lore = PlainTextComponentSerializer.plainText().serialize(componentLore)).startsWith("\u00a7{i.") && (message2 = ItemDictionary.get(id2 = Integer.parseInt(lore.split("\\.")[1].replace("}", "")))) != null) {
                            loreList.add(i, message2.build(player.getLanguage()));
                            continue;
                        }
                        loreList.add(i, componentLore);
                    }
                    meta.lore(loreList);
                    item.setItemMeta(meta);
                }
                packet.setSlotData(item);
            }
        } else if (event.getPacketType() == PacketType.Play.Server.WINDOW_ITEMS) {
            WrapperPlayServerWindowItems packet = new WrapperPlayServerWindowItems(event.getPacket());
            ArrayList<ItemStack> data = new ArrayList<ItemStack>(packet.getSlotData().size());
            for (ItemStack item : packet.getSlotData()) {
                int id;
                TextMessage message;
                String name;
                Component componentName;
                if (item == null) continue;
                ItemMeta meta = item.getItemMeta();
                if (meta != null && (componentName = meta.displayName()) != null && (name = PlainTextComponentSerializer.plainText().serialize(componentName)).startsWith("\u00a7{i.") && (message = ItemDictionary.get(id = Integer.parseInt(name.split("\\.")[1].replace("}", "")))) != null) {
                    meta.displayName(message.build(player.getLanguage()));
                    item.setItemMeta(meta);
                }
                if ((meta = item.getItemMeta()) != null && meta.lore() != null) {
                    ArrayList<Component> loreList = new ArrayList<Component>(meta.lore().size());
                    for (int i = 0; i < meta.lore().size(); ++i) {
                        int id3;
                        TextMessage message3;
                        String lore;
                        Component componentLore = (Component)meta.lore().get(i);
                        if (componentLore != null && (lore = PlainTextComponentSerializer.plainText().serialize(componentLore)).startsWith("\u00a7{i.") && (message3 = ItemDictionary.get(id3 = Integer.parseInt(lore.split("\\.")[1].replace("}", "")))) != null) {
                            loreList.add(i, message3.build(player.getLanguage()));
                            continue;
                        }
                        loreList.add(i, componentLore);
                    }
                    meta.lore(loreList);
                    item.setItemMeta(meta);
                }
                data.add(item);
            }
            packet.setSlotData(data);
        }
    }
}

