/*
 * Decompiled with CFR 0.152.
 */
package moe.amy.paper.player;

import java.util.UUID;
import moe.amy.api.AmyPI;
import moe.amy.api.player.OfflinePlayer;
import moe.amy.api.player.OnlinePlayer;
import moe.amy.api.player.WrappedPlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class OfflinePlayerPaper
implements OfflinePlayer {
    private final UUID uuid;
    private final String name;

    protected OfflinePlayerPaper(Player player) {
        this.uuid = player.getUniqueId();
        this.name = player.getName();
    }

    protected OfflinePlayerPaper(UUID uuid, String name) {
        this.uuid = uuid;
        this.name = name;
    }

    @Override
    @NotNull
    public UUID getUniqueId() {
        return this.uuid;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isOnline() {
        return this.getOnlinePlayer() != null;
    }

    @Override
    public OnlinePlayer getOnlinePlayer() {
        return AmyPI.getPlayerManager().getOnlinePlayer(this.uuid);
    }

    public boolean equals(Object o) {
        if (o instanceof OfflinePlayer) {
            OfflinePlayer other = (OfflinePlayer)o;
            return this.getUniqueId().equals(other.getUniqueId());
        }
        if (o instanceof WrappedPlayer) {
            WrappedPlayer other = (WrappedPlayer)o;
            return this.getUniqueId().equals(other.getOnlinePlayer().getUniqueId());
        }
        if (o instanceof Player) {
            Player other = (Player)o;
            return this.getUniqueId().equals(other.getUniqueId());
        }
        if (o instanceof UUID) {
            UUID other = (UUID)o;
            return this.getUniqueId().equals(other);
        }
        return false;
    }
}

