/*
 * Decompiled with CFR 0.152.
 */
package moe.amy.paper.player;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import moe.amy.api.AmyPI;
import moe.amy.api.player.OnlinePlayer;
import moe.amy.api.player.WrappedPlayer;
import moe.amy.api.text.Language;
import moe.amy.api.text.LiteralMessage;
import moe.amy.api.text.TextMessage;
import moe.amy.api.util.Location;
import moe.amy.paper.player.OfflinePlayerPaper;
import moe.amy.paper.util.LocationUtils;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.title.Title;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.PlayerInventory;
import org.jetbrains.annotations.NotNull;

public class OnlinePlayerPaper
extends OfflinePlayerPaper
implements OnlinePlayer {
    private final Player player;
    private TextMessage chatName;
    private Language language = Language.getDefaultLanguage();
    private final Map<String, Long> cooldowns = new HashMap<String, Long>();
    private final HashMap<Class<? extends WrappedPlayer>, Object> wrappedPlayers = new HashMap();

    public OnlinePlayerPaper(Player player) {
        super(player);
        this.player = player;
        this.chatName = new LiteralMessage(player.getName());
    }

    @NotNull
    public Player getHandle() {
        return this.player;
    }

    @Override
    @NotNull
    public String getName() {
        return this.player.getName();
    }

    @Override
    @NotNull
    public TextMessage getChatName() {
        return this.chatName;
    }

    @Override
    public void setChatName(@NotNull TextMessage chatName) {
        this.chatName = chatName;
    }

    @Override
    public boolean hasPermission(String permission) {
        return this.player.hasPermission(permission);
    }

    @Override
    @NotNull
    public Language getLanguage() {
        return this.language;
    }

    @Override
    public void setLanguage(@NotNull Language language) {
        this.language = language;
    }

    @Override
    public void sendMessage() {
        this.player.sendMessage((Component)Component.empty());
    }

    @Override
    public void sendMessage(TextMessage message) {
        if (message == null) {
            this.player.sendMessage((Component)Component.empty());
        } else {
            this.player.sendMessage(message.build(this.getLanguage()));
        }
    }

    @Override
    public void sendMessage(TextMessage ... messages) {
        for (TextMessage message : messages) {
            if (message == null) {
                this.player.sendMessage((Component)Component.empty());
                continue;
            }
            this.player.sendMessage(message.build(this.getLanguage()));
        }
    }

    @Override
    @NotNull
    public UUID getUniqueId() {
        return this.player.getUniqueId();
    }

    @Override
    public void setTabHeaderFooter(TextMessage header, TextMessage footer) {
        this.player.sendPlayerListHeaderAndFooter(header.build(this.getLanguage()), footer.build(this.getLanguage()));
    }

    @Override
    public void sendTitle(TextMessage title) {
        this.player.showTitle(Title.title((Component)title.build(this.getLanguage()), (Component)Component.text((String)"")));
    }

    @Override
    public void sendSubtitle(TextMessage subtitle) {
        this.player.showTitle(Title.title((Component)Component.text((String)""), (Component)subtitle.build(this.getLanguage())));
    }

    @Override
    public void sendTitleAndSubtitle(TextMessage title, TextMessage subtitle) {
        this.player.showTitle(Title.title((Component)title.build(this.getLanguage()), (Component)subtitle.build(this.getLanguage())));
    }

    @Override
    public void clearTitles() {
        this.player.clearTitle();
    }

    @Override
    public void sendActionBar(TextMessage actionBar) {
        this.player.sendActionBar(actionBar.build(this.getLanguage()));
    }

    @Override
    public void playSound(Sound sound) {
        this.player.playSound(sound);
    }

    @Override
    public void playSound(Sound sound, Location location) {
        this.player.playSound(sound, location.getX(), location.getY(), location.getZ());
    }

    @Override
    public void playSound(Sound sound, Sound.Emitter emitter) {
        this.player.playSound(sound, emitter);
    }

    @Override
    public void teleport(@NotNull Location location) {
        World world = location.getWorld() == null ? this.player.getWorld() : Bukkit.getWorld((String)location.getWorld());
        this.player.teleport(new org.bukkit.Location(world, location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch()));
    }

    @Override
    public void teleport(@NotNull OnlinePlayer other) {
        this.player.teleport((Entity)((OnlinePlayerPaper)other).getHandle());
    }

    @Override
    public Location getLocation() {
        org.bukkit.Location bukkitLoc = this.player.getLocation();
        return new Location(this.player.getWorld().getName(), bukkitLoc.getX(), bukkitLoc.getY(), bukkitLoc.getZ(), bukkitLoc.getYaw(), bukkitLoc.getPitch());
    }

    @Override
    public CompletableFuture<Location> getLocationAsync() {
        CompletableFuture<Location> callback = new CompletableFuture<Location>();
        callback.complete(this.getLocation());
        return callback;
    }

    public PlayerInventory getInventory() {
        return this.player.getInventory();
    }

    public OnlinePlayerPaper getClosestPlayer() {
        OnlinePlayer result = null;
        double lastDistance = Double.MAX_VALUE;
        for (OnlinePlayer onlinePlayer : AmyPI.getPlayerManager().getAllPlayers()) {
            double distance;
            Player p = (Player)onlinePlayer.getHandle();
            if (this.player == p || this.player.getWorld() != this.getHandle().getWorld() || !((distance = this.player.getLocation().distanceSquared(p.getLocation())) < lastDistance)) continue;
            lastDistance = distance;
            result = onlinePlayer;
        }
        return (OnlinePlayerPaper)result;
    }

    public void setCompassTarget(Location location) {
        this.player.setCompassTarget(LocationUtils.toBukkitLocation(location));
    }

    @Override
    public boolean triggerCooldown(String key, int cooldown) {
        if (!this.cooldowns.containsKey(key)) {
            this.cooldowns.put(key, System.currentTimeMillis() + (long)cooldown);
            return true;
        }
        long time = this.cooldowns.get(key);
        if (time < System.currentTimeMillis()) {
            this.cooldowns.put(key, System.currentTimeMillis() + (long)cooldown);
            return true;
        }
        return false;
    }

    @Override
    public <T extends WrappedPlayer> T wrap(Class<T> clazz) {
        Object obj = this.wrappedPlayers.computeIfAbsent(clazz, c -> {
            try {
                WrappedPlayer wrapped = (WrappedPlayer)c.getConstructor(new Class[0]).newInstance(new Object[0]);
                wrapped.create(this);
                return wrapped;
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
                return null;
            }
        });
        if (clazz.isInstance(obj)) {
            return (T)((WrappedPlayer)clazz.cast(obj));
        }
        throw new ClassCastException("Object is not of type " + clazz.getName());
    }
}

