/*
 * Decompiled with CFR 0.152.
 */
package moe.amy.paper.util;

import com.comphenix.protocol.wrappers.WrappedGameProfile;
import com.comphenix.protocol.wrappers.WrappedSignedProperty;
import com.mojang.authlib.GameProfile;
import java.util.UUID;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class SkinData {
    public final UUID uuid;
    public final String texture;
    public final String signature;

    public SkinData(String texture) {
        this(UUID.randomUUID(), texture, "null");
    }

    public SkinData(String texture, String signature) {
        this(UUID.randomUUID(), texture, signature);
    }

    public SkinData(UUID uuid, String texture, String signature) {
        this.uuid = uuid;
        this.texture = texture;
        this.signature = signature;
    }

    public boolean equals(Object o) {
        if (o instanceof SkinData) {
            SkinData other = (SkinData)o;
            return other.texture.equals(this.texture) && other.signature.equals(this.signature);
        }
        return false;
    }

    public WrappedGameProfile toWrappedGameProfile(String name) {
        WrappedGameProfile profile = new WrappedGameProfile(this.uuid, name);
        profile.getProperties().put((Object)"textures", (Object)WrappedSignedProperty.fromValues((String)"textures", (String)this.texture, (String)this.signature));
        return profile;
    }

    public GameProfile toGameProfile(String name) {
        return (GameProfile)this.toWrappedGameProfile(name).getHandle();
    }

    public static SkinData getSkinData(Player player) {
        WrappedGameProfile profile = WrappedGameProfile.fromPlayer((Player)player);
        for (WrappedSignedProperty property : profile.getProperties().get((Object)"textures")) {
            if (!property.getName().equalsIgnoreCase("textures")) continue;
            return new SkinData(profile.getUUID(), property.getValue(), property.getSignature());
        }
        return null;
    }

    public static SkinData getSkinData(OfflinePlayer player) {
        WrappedGameProfile profile = WrappedGameProfile.fromOfflinePlayer((OfflinePlayer)player);
        for (WrappedSignedProperty property : profile.getProperties().get((Object)"textures")) {
            if (!property.getName().equalsIgnoreCase("textures")) continue;
            return new SkinData(profile.getUUID(), property.getValue(), property.getSignature());
        }
        return null;
    }
}

